<?php


/* ==========================================================================
   Part 1. Functions to pack and unpack data.
   ========================================================================== */
function packStructure($structure, $user_data)
{
	/*
	Packs the data of an associative tree-shaped array ($user_data) into 
	*/
	
	foreach($structure as $k => $v)
	{
		$v2 = (isset($user_data[$k]) ? $user_data[$k] : 0);
		
		if (is_array($v))
			$str .= packStructure($v, $v2);
		else
			$str .= pack($v, $v2);
	}

	return $str;
}

	/*
	This function takes a one-dimensional $user_data and shapes it as the tree-shaped $structure.
	
	It is used to shape the data that was received in a binary packet and unpack()-ed.
	
	Arguments:
	$structure
				one of InSim structures (see insim_structure.export), associative array tree
	             
	$user_data
				user data, any one-dimensional array. The elements must be in the proper order, for example
	
	$structure = array("truck" => array("driver" => null, "load" => null), "road" => null);
	$user_data = array("detail", "kiwi", "highway");
	
	the function will return
	array(
	       "truck" => array(
	                       "driver" => "detail",
	                       "load" => "kiwi"),
	       "road" => "highway");	
	*/
function unpackStructure($structure, &$data)
{
	foreach($structure as $k => $v)
		if (is_array($v))
			$result[$k] = unpackStructure($v, $data);
		else
			$result[$k] = array_shift($data);

	return $result;
}

function compPacket($data)
{
	/*
	Composes a packet of an array of $data into a binary string.
	
	$data must be an associative array according to one of the InSim structures and contain a "Type" element with a correct InSim packet type constant, for example array("Type" => ISP_ISI, "UDPPort" => 30000, ... ).
	
	The "Size" component is not necessary, since the size is calculated below, on the fly.
	*/
	$type = $data["Type"];
	$pack = packStructure($GLOBALS["LFS_STRUCT"][$type], $data);
	
	$data["Size"] = strlen($pack);
	return pack("C", strlen($pack)) . substr($pack, 1);
}

function decompPacket($data)
{
	/*
	Decomposes a binary string of $data (usually an InSim packet) into an associative array, shaped as one of the InSim structures. The structure number must be stored in the second byte.
	*/
	
	// reading the type of the structure (2nd byte)
	$type = unpack("C", substr($data, 1, 1));
	$type = $type[1];


	
	if ($type == ISP_MCI)
		$data = str_pad($data, 228, "\x00");
	elseif ($type == ISP_NLP)
		$data = str_pad($data, 196, "\x00");


	
	if (!isset($GLOBALS["LFS_STRUCT"][$type]))
		return false;

	// Here, unpack() produces a 1-dimensional associative array, and unpackStructure arranges it according to the structure array.
	return unpackStructure($GLOBALS["LFS_STRUCT"][$type],
			unpack($GLOBALS["LFS_USTRING"][$type], $data));
}


/* ==========================================================================
   Part 3. Functions for the most used outgoing packets.
   ========================================================================== */


/* ==========================================================================
   Part 4. Miscellaneous functions.
   ========================================================================== */

function maxMin($max, $min, $val)
{
	// Limits $val into the [$min, $max] range.
	return min($max, max($min, $val));
}
	

function writeRoutine($file, $data)
{
	/*
	Appends current time and $data string to the $file.
	*/
	$f = fopen($file, "a");
	fwrite($f, "\n". date("M-d H:i:s."). round(fmod(microtime(true), time())*1000, 0). "\n". $data. "\n");
	fclose($f);
}

